/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.search;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.core.model.IField;
import com.aptana.editor.php.core.model.IMethod;
import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.IType;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.indexer.IIndexChangeListener;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.builder.BuildPathManager;
import com.aptana.editor.php.internal.builder.FileSystemModule;
import com.aptana.editor.php.internal.builder.LocalModule;
import com.aptana.editor.php.internal.contentAssist.ContentAssistFilters;
import com.aptana.editor.php.internal.contentAssist.mapping.PHPOffsetMapper;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.TraitPHPEntryValue;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import com.aptana.editor.php.internal.model.utils.ModelUtils;
import com.aptana.editor.php.internal.parser.PHPParser;
import com.aptana.editor.php.internal.parser.nodes.IPHPParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPClassParseNode;
import com.aptana.editor.php.internal.refactoring.RefactoringUtils;
import com.aptana.editor.php.internal.search.ExternalReference;
import com.aptana.editor.php.internal.search.IElementNode;
import com.aptana.editor.php.internal.search.IMethodReference;
import com.aptana.editor.php.internal.search.ISearchScope;
import com.aptana.editor.php.internal.search.ITypeNode;
import com.aptana.editor.php.internal.ui.editor.PHPSourceEditor;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org2.eclipse.php.core.compiler.PHPFlags;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.TypeDeclaration;

public final class PHPSearchEngine {
    private static PHPSearchEngine instance;

    public IPHPParseNode resolveClass(String name) {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof PHPSourceEditor) {
            Set<IElementEntry> filterByModule;
            PHPSourceEditor editor = (PHPSourceEditor)activeEditor;
            PHPOffsetMapper mapper = editor.getOffsetMapper();
            String source = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get();
            IElementsIndex index = mapper.getIndex(source, source.length());
            IModule emodule = editor.getModule();
            List<IElementEntry> entries = index.getEntries(-1, name);
            if (emodule != null) {
                filterByModule = ContentAssistFilters.filterByModule(entries, emodule, index);
            } else {
                filterByModule = new HashSet<IElementEntry>(entries.size());
                filterByModule.addAll(entries);
            }
            for (IElementEntry e : filterByModule) {
                if (!(e.getValue() instanceof ClassPHPEntryValue)) continue;
                IModule module = e.getModule();
                try {
                    PHPParser parser = new PHPParser(PHPVersion.getLatest(), false);
                    IParseRootNode parseNode = parser.parse(module.getContents());
                    IParseNode findClassNode = this.findClassNode((IParseNode)parseNode, name);
                    return (IPHPParseNode)findClassNode;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return null;
    }

    private IParseNode findClassNode(IParseNode populateNodes, String name) {
        if (populateNodes instanceof IPHPParseNode) {
            IParseNode[] children;
            IPHPParseNode pn = (IPHPParseNode)populateNodes;
            if (pn.getNodeName().equals(name) && pn instanceof PHPClassParseNode) {
                return pn;
            }
            IParseNode[] iParseNodeArray = children = pn.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode n3 = iParseNodeArray[n2];
                IParseNode findClassNode = this.findClassNode(n3, name);
                if (findClassNode != null) {
                    return findClassNode;
                }
                ++n2;
            }
        }
        return null;
    }

    public ExternalReference resolveClassToReference(String name) {
        IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Missing implementation for PHPSearchEngine::resolveClassToReference()", (String)"com.aptana.editor.php/debug");
        return null;
    }

    public Collection<ITypeNode> getAllKnownTypes() {
        List<IElementEntry> entriesStartingWith = PHPGlobalIndexer.getInstance().getIndex().getEntriesStartingWith(1, "");
        ArrayList<ITypeNode> nodes = new ArrayList<ITypeNode>();
        for (IElementEntry e : entriesStartingWith) {
            this.processValue(nodes, e);
        }
        return nodes;
    }

    private void processValue(List nodes, IElementEntry e) {
        Object value = e.getValue();
        if (value instanceof TraitPHPEntryValue) {
            TraitPHPEntryValue tv = (TraitPHPEntryValue)value;
            TraitNode node = new TraitNode(e, tv);
            nodes.add(node);
        } else if (value instanceof ClassPHPEntryValue) {
            ClassPHPEntryValue ea = (ClassPHPEntryValue)value;
            ClassNode node = new ClassNode(e, ea);
            nodes.add(node);
        } else if (value instanceof FunctionPHPEntryValue) {
            FunctionPHPEntryValue pa = (FunctionPHPEntryValue)value;
            nodes.add(new ElementNode(e, pa, 2, null, null));
        } else if (value instanceof VariablePHPEntryValue) {
            VariablePHPEntryValue pa = (VariablePHPEntryValue)value;
            nodes.add(new ElementNode(e, pa, 3, null, null));
        }
    }

    PHPClassParseNode getClassNode(IElementEntry e) {
        if (e.getValue() instanceof ClassPHPEntryValue) {
            IModule module = e.getModule();
            try {
                PHPParser parser = new PHPParser(PHPVersion.getLatest(), false);
                IParseRootNode parseNode = parser.parse(module.getContents());
                IParseNode findClassNode = this.findClassNode((IParseNode)parseNode, e.getEntryPath());
                return (PHPClassParseNode)findClassNode;
            }
            catch (Exception ex) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error getting a PHP class node", (Throwable)ex);
            }
        }
        return null;
    }

    public void addListener(IIndexChangeListener listener) {
        PHPGlobalIndexer.getInstance().addListener(listener);
    }

    public void removeListener(IIndexChangeListener listener) {
        PHPGlobalIndexer.getInstance().removeListener(listener);
    }

    public Collection<ITypeNode> getTypes(String name) {
        List<IElementEntry> entriesStartingWith = PHPGlobalIndexer.getInstance().getIndex().getEntries(1, name);
        ArrayList<ITypeNode> nodes = new ArrayList<ITypeNode>();
        for (IElementEntry e : entriesStartingWith) {
            this.processValue(nodes, e);
        }
        return nodes;
    }

    public Collection<IElementNode> getAllKnownConstants() {
        List<IElementEntry> entriesStartingWith = PHPGlobalIndexer.getInstance().getIndex().getEntriesStartingWith(4, "");
        ArrayList<IElementNode> nodes = new ArrayList<IElementNode>();
        for (IElementEntry e : entriesStartingWith) {
            this.processValue(nodes, e);
        }
        return nodes;
    }

    public Collection<IElementNode> getAllKnownFunctions() {
        List<IElementEntry> entriesStartingWith = PHPGlobalIndexer.getInstance().getIndex().getEntriesStartingWith(2, "");
        ArrayList<IElementNode> nodes = new ArrayList<IElementNode>();
        for (IElementEntry e : entriesStartingWith) {
            this.processValue(nodes, e);
        }
        return nodes;
    }

    public IMethodReference findOverriddenMethod(MethodDeclaration node) {
        HashSet<String> visited;
        String classname;
        IMethodReference checkType;
        ClassDeclaration decl;
        Expression superClass;
        ASTNode parent = node.getParent().getParent();
        String methodname = node.getFunction().getFunctionName().getName();
        if (parent instanceof ClassDeclaration && (superClass = (decl = (ClassDeclaration)parent).getSuperClass()) != null && superClass.getType() == 33 && (checkType = this.checkType(classname = ((Identifier)superClass).getName(), methodname, visited = new HashSet<String>())) != null) {
            return checkType;
        }
        if (parent instanceof TypeDeclaration) {
            decl = (TypeDeclaration)parent;
            for (Identifier i : decl.interfaces()) {
                String name = i.getName();
                checkType = this.checkType(name, methodname, new HashSet<String>());
                if (checkType == null) continue;
                return checkType;
            }
        }
        return null;
    }

    private IMethodReference checkType(final String classname, final String methodname, Set<String> visited) {
        if (!visited.contains(classname)) {
            visited.add(classname);
            IElementsIndex index = PHPGlobalIndexer.getInstance().getIndex();
            List<IElementEntry> entries = index.getEntries(1, classname);
            for (IElementEntry e : entries) {
                IMethodReference checkType;
                Iterator<IElementEntry> iterator;
                final ClassPHPEntryValue value = (ClassPHPEntryValue)e.getValue();
                List<IElementEntry> entries2 = index.getEntries(2, String.valueOf(classname) + '/' + methodname);
                if (entries2 != null && !entries2.isEmpty() && (iterator = entries2.iterator()).hasNext()) {
                    final IElementEntry ea = iterator.next();
                    final FunctionPHPEntryValue mvalue = (FunctionPHPEntryValue)ea.getValue();
                    return new IMethodReference(){

                        @Override
                        public String getQualifiedName() {
                            return String.valueOf(classname) + "." + methodname;
                        }

                        @Override
                        public String name() {
                            return methodname;
                        }

                        @Override
                        public ExternalReference toExternalReference() {
                            IModule module = ea.getModule();
                            Range range = new Range(mvalue.getStartOffset(), mvalue.getStartOffset());
                            return PHPSearchEngine.this.getModuleReference(module, range);
                        }

                        @Override
                        public boolean isAbstract() {
                            return PHPFlags.isAbstract((int)mvalue.getModifiers()) || PHPFlags.isInterface((int)value.getModifiers());
                        }
                    };
                }
                String superClassname = value.getSuperClassname();
                if (superClassname != null && superClassname.length() > 0 && (checkType = this.checkType(superClassname, methodname, visited)) != null) {
                    return checkType;
                }
                List<String> interfaces = value.getInterfaces();
                if (interfaces == null) continue;
                for (String s : interfaces) {
                    IMethodReference checkType2 = this.checkType(s, methodname, visited);
                    if (checkType2 == null) continue;
                    return checkType2;
                }
            }
        }
        return null;
    }

    protected ExternalReference getModuleReference(IModule module, Range range) {
        if (module instanceof LocalModule) {
            LocalModule lmodule = (LocalModule)module;
            FileEditorInput fileEditorInput = new FileEditorInput(lmodule.getFile());
            return new ExternalReference((IEditorInput)fileEditorInput, (IRange)range);
        }
        if (module instanceof FileSystemModule) {
            try {
                return new ExternalReference((IEditorInput)new FileStoreEditorInput(EFS.getStore((URI)((FileSystemModule)module).getExternalFile().getURI())), (IRange)range);
            }
            catch (CoreException ce) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error computing the external reference", (Throwable)ce);
            }
        }
        return null;
    }

    private PHPSearchEngine() {
    }

    public static synchronized PHPSearchEngine getInstance() {
        if (instance == null) {
            instance = new PHPSearchEngine();
        }
        return instance;
    }

    public IType[] findTypes(String name, ISearchScope scope) {
        List<IElementEntry> entries = PHPGlobalIndexer.getInstance().getIndex().getEntries(1, name);
        if (entries != null) {
            List<IType> convertClasses = ModelUtils.convertTypes(entries);
            return convertClasses.toArray(new IType[convertClasses.size()]);
        }
        return null;
    }

    public IMethod[] findMethods(String name, ISearchScope scope) {
        List<IElementEntry> entries = PHPGlobalIndexer.getInstance().getIndex().getEntries(2, name);
        if (entries != null) {
            List<IModelElement> convertClasses = ModelUtils.convertEntries(entries);
            return convertClasses.toArray(new IMethod[convertClasses.size()]);
        }
        return null;
    }

    public IField[] findVariables(String name, ISearchScope scope) {
        List<IElementEntry> entries = PHPGlobalIndexer.getInstance().getIndex().getEntries(3, name);
        if (entries != null) {
            List<IModelElement> convertClasses = ModelUtils.convertEntries(entries);
            return convertClasses.toArray(new IField[convertClasses.size()]);
        }
        return null;
    }

    public IField[] findConstants(String name, ISearchScope scope) {
        List<IElementEntry> entries = PHPGlobalIndexer.getInstance().getIndex().getEntries(4, name);
        if (entries != null) {
            List<IModelElement> convertClasses = ModelUtils.convertEntries(entries);
            return convertClasses.toArray(new IField[convertClasses.size()]);
        }
        return null;
    }

    private class ClassNode
    extends ElementNode
    implements ITypeNode {
        protected ClassNode(IElementEntry e, ClassPHPEntryValue ea, int kind) {
            super(e, ea, kind);
        }

        private ClassNode(IElementEntry e, ClassPHPEntryValue ea) {
            this(e, ea, 1);
        }

        @Override
        public boolean isOnBuildPath(IProject project) {
            IBuildPath buildPathByResource = BuildPathManager.getInstance().getBuildPathByResource(project);
            HashSet<IBuildPath> pa = new HashSet<IBuildPath>();
            pa.add(buildPathByResource);
            pa.addAll(buildPathByResource.getDependencies());
            return pa.contains(this.e.getModule().getBuildPath());
        }

        @Override
        public PHPClassParseNode toParseNode() {
            return PHPSearchEngine.this.getClassNode(this.e);
        }

        @Override
        public String getIncludePath(IFile from) {
            String constructPathFromRoot = RefactoringUtils.constructPathFromRoot(this.e.getModule().getPath());
            Path typePath = new Path(constructPathFromRoot);
            IPath fullPath = from.getProjectRelativePath();
            IPath commonRoot = fullPath.removeLastSegments(1);
            int count = 0;
            while (commonRoot != null && !commonRoot.isPrefixOf((IPath)typePath)) {
                commonRoot = commonRoot.removeLastSegments(1);
                ++count;
            }
            StringBuilder result = new StringBuilder();
            int pos = count;
            while (count > 0) {
                result.append("../");
                --count;
            }
            if (pos > 0) {
                IPath removeFirstSegments = typePath.removeFirstSegments(commonRoot.segmentCount());
                result.append(removeFirstSegments.toPortableString());
            } else {
                result.append("./");
                result.append(typePath.toPortableString());
            }
            return result.toString();
        }
    }

    private static class ElementNode
    implements IElementNode {
        protected final IElementEntry e;
        protected final AbstractPHPEntryValue value;
        private int kind;

        private ElementNode(IElementEntry e, AbstractPHPEntryValue ea, int kind) {
            this.e = e;
            this.value = ea;
            this.kind = kind;
        }

        @Override
        public ExternalReference toExternalReference() {
            IModule module = this.e.getModule();
            Range range = new Range(this.value.getStartOffset(), this.value.getStartOffset());
            return PHPSearchEngine.getInstance().getModuleReference(module, range);
        }

        @Override
        public int getModifiers() {
            return this.value.getModifiers();
        }

        @Override
        public String getName() {
            return this.e.getEntryPath();
        }

        @Override
        public String getPath() {
            IModule module = this.e.getModule();
            if (module instanceof LocalModule) {
                LocalModule mz = (LocalModule)module;
                return mz.getFile().getFullPath().toPortableString().substring(1);
            }
            return module.getFullPath();
        }

        @Override
        public int getKind() {
            return this.kind;
        }

        /* synthetic */ ElementNode(IElementEntry iElementEntry, AbstractPHPEntryValue abstractPHPEntryValue, int n, ElementNode elementNode, ElementNode elementNode2) {
            this(iElementEntry, abstractPHPEntryValue, n);
        }
    }

    private class TraitNode
    extends ClassNode {
        protected TraitNode(IElementEntry e, ClassPHPEntryValue ea) {
            super(e, ea, 4);
        }
    }
}

